<?php
/**
 * EverestForms Field Description Config Functions
 *
 * @package EverestForms_Style_Customizer/Functions
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * Add everest forms style customizer sections.
 *
 * @param array $sections Array of sections.
 */
function evf_style_customizer_field_description_sections( $sections ) {
	return array_merge(
		$sections,
		array(
			'everest_forms_field_description' => array(
				'title'              => esc_html__( 'Field Description', 'everest-forms-style-customizer' ),
				'description'        => esc_html__( 'This is field description section.', 'everest-forms-style-customizer' ),
				'priority'           => 10,
				'description_hidden' => true,
			),
		)
	);
}
add_filter( 'everest_forms_style_customizer_sections', 'evf_style_customizer_field_description_sections' );

/**
 * Add everest forms style customizer controls.
 *
 * @param array $controls Array of controls.
 */
function evf_style_customizer_field_description_controls( $controls ) {
	$controls['field_description'] = array(
		'font_size'      => array(
			'setting' => array(
				'default'           => '14',
				'sanitize_callback' => 'sanitize_text_field',
			),
			'control' => array(
				'label'       => esc_html__( 'Font Size', 'everest-forms-style-customizer' ),
				'description' => esc_html__( 'This is a form field description font size (px).', 'everest-forms-style-customizer' ),
				'section'     => 'everest_forms_field_description',
				'type'        => 'EVF_Customize_Slider_Control',
				'input_attrs' => array(
					'min'  => 10,
					'max'  => 50,
					'step' => 1,
				),
			),
		),
		'font_color'     => array(
			'setting' => array(
				'default' => '#575757',
			),
			'control' => array(
				'label'       => esc_html__( 'Font Color', 'everest-forms-style-customizer' ),
				'description' => esc_html__( 'This is a form field description font color.', 'everest-forms-style-customizer' ),
				'section'     => 'everest_forms_field_description',
				'type'        => 'EVF_Customize_Color_Control',
			),
		),
		'font_style'     => array(
			'setting' => array(
				'default' => array(
					'bold'      => false,
					'italic'    => false,
					'underline' => false,
					'uppercase' => false,
				),
			),
			'control' => array(
				'label'       => esc_html__( 'Font Style', 'everest-forms-style-customizer' ),
				'description' => esc_html__( 'This is a form field description font style.', 'everest-forms-style-customizer' ),
				'section'     => 'everest_forms_field_description',
				'type'        => 'EVF_Customize_Image_Checkbox_Control',
				'choices'     => array(
					'bold'      => array(
						'name'  => esc_html__( 'Bold', 'everest-forms-style-customizer' ),
						'image' => plugins_url( 'assets/images/bold.svg', EVF_STYLE_CUSTOMIZER_PLUGIN_FILE ),
					),
					'italic'    => array(
						'name'  => esc_html__( 'Italic', 'everest-forms-style-customizer' ),
						'image' => plugins_url( 'assets/images/italic.svg', EVF_STYLE_CUSTOMIZER_PLUGIN_FILE ),
					),
					'underline' => array(
						'name'  => esc_html__( 'Underline', 'everest-forms-style-customizer' ),
						'image' => plugins_url( 'assets/images/underline.svg', EVF_STYLE_CUSTOMIZER_PLUGIN_FILE ),
					),
					'uppercase' => array(
						'name'  => esc_html__( 'Uppercase', 'everest-forms-style-customizer' ),
						'image' => plugins_url( 'assets/images/uppercase.svg', EVF_STYLE_CUSTOMIZER_PLUGIN_FILE ),
					),
				),
			),
		),
		'text_alignment' => array(
			'setting' => array(
				'default'           => 'left',
				'sanitize_callback' => 'sanitize_text_field',
			),
			'control' => array(
				'label'       => esc_html__( 'Text Alignment', 'everest-forms-style-customizer' ),
				'description' => esc_html__( 'This is a form field description text alignment.', 'everest-forms-style-customizer' ),
				'section'     => 'everest_forms_field_description',
				'type'        => 'EVF_Customize_Image_Radio_Control',
				'choices'     => array(
					'left'   => array(
						'name'  => esc_html__( 'Left', 'everest-forms-style-customizer' ),
						'image' => plugins_url( 'assets/images/align-left.svg', EVF_STYLE_CUSTOMIZER_PLUGIN_FILE ),
					),
					'center' => array(
						'name'  => esc_html__( 'Center', 'everest-forms-style-customizer' ),
						'image' => plugins_url( 'assets/images/align-center.svg', EVF_STYLE_CUSTOMIZER_PLUGIN_FILE ),
					),
					'right'  => array(
						'name'  => esc_html__( 'Right', 'everest-forms-style-customizer' ),
						'image' => plugins_url( 'assets/images/align-right.svg', EVF_STYLE_CUSTOMIZER_PLUGIN_FILE ),
					),
				),
			),
		),
		'line_height'    => array(
			'setting' => array(
				'default'           => '1.7',
				'sanitize_callback' => 'sanitize_text_field',
			),
			'control' => array(
				'label'       => esc_html__( 'Line Height', 'everest-forms-style-customizer' ),
				'description' => esc_html__( 'This is a form field description line height.', 'everest-forms-style-customizer' ),
				'section'     => 'everest_forms_field_description',
				'type'        => 'EVF_Customize_Slider_Control',
				'input_attrs' => array(
					'min'  => 1,
					'max'  => 3,
					'step' => .01,
				),
			),
		),
		'margin'         => array(
			'setting' => array(
				'default' => array(
					'desktop' => array(
						'top'    => 0,
						'right'  => 0,
						'bottom' => 10,
						'left'   => 0,
					),
				),
			),
			'control' => array(
				'label'       => esc_html__( 'Margin', 'everest-forms-style-customizer' ),
				'description' => esc_html__( 'This is a form field description margin.', 'everest-forms-style-customizer' ),
				'section'     => 'everest_forms_field_description',
				'type'        => 'EVF_Customize_Dimension_Control',
				'custom_args' => array(
					'anchor'     => true,
					'responsive' => true,
					'input_type' => 'number',
				),
			),
		),
		'padding'        => array(
			'setting' => array(
				'default' => array(
					'desktop' => array(
						'top'    => 0,
						'right'  => 0,
						'bottom' => 0,
						'left'   => 0,
					),
				),
			),
			'control' => array(
				'label'       => esc_html__( 'Padding', 'everest-forms-style-customizer' ),
				'description' => esc_html__( 'This is a form field description padding.', 'everest-forms-style-customizer' ),
				'section'     => 'everest_forms_field_description',
				'type'        => 'EVF_Customize_Dimension_Control',
				'input_attrs' => array(
					'min' => 0,
				),
				'custom_args' => array(
					'anchor'     => true,
					'responsive' => true,
					'input_type' => 'number',
				),
			),
		),
	);

	return $controls;
}
add_filter( 'everest_forms_style_customizer_controls', 'evf_style_customizer_field_description_controls' );
