<?php
/**
 * Admin View: Entries
 *
 * @package EverestForms_Pro/Entries/Edit
 *
 * @todo Add date modified in the edit entry.
 */

defined( 'ABSPATH' ) || exit;

$form_id    = isset( $_GET['form_id'] ) ? absint( $_GET['form_id'] ) : 0; // phpcs:ignore WordPress.Security.NonceVerification
$entry_id   = isset( $_GET['edit-entry'] ) ? absint( $_GET['edit-entry'] ) : 0; // phpcs:ignore WordPress.Security.NonceVerification
$entry      = evf_get_entry( $entry_id, true );
$form_data  = evf()->form->get( $form_id, array( 'content_only' => true ) );
$hide_empty = isset( $_COOKIE['everest_forms_entry_hide_empty'] ) && 'true' === $_COOKIE['everest_forms_entry_hide_empty'];
$form_atts  = array(
	'id'    => 'everest-forms-edit-entry-form',
	'class' => array( 'everest-form', 'everest-forms-validate' ),
	'data'  => array(
		'formid' => $form_id,
	),
	'atts'  => array(
		'method'  => 'POST',
		'enctype' => 'multipart/form-data',
		'action'  => esc_url_raw( remove_query_arg( 'everest-forms' ) ),
	),
);
$trash_link = wp_nonce_url(
	add_query_arg(
		array(
			'trash' => $entry_id,
		),
		admin_url( 'admin.php?page=evf-entries&amp;form_id=' . $form_id )
	),
	'trash-entry'
);

?>
<div class="wrap everest-forms">
	<h1 class="wp-heading-inline"><?php esc_html_e( 'Edit Entry', 'everest-forms-pro' ); ?></h1>
	<a href="<?php echo esc_url( admin_url( 'admin.php?page=evf-entries&amp;form_id=' . $form_id ) ); ?>" class="page-title-action"><?php esc_html_e( 'Back to All Entries', 'everest-forms-pro' ); ?></a>
	<hr class="wp-header-end">
	<div class="everest-forms-entry">
		<div id="poststuff">
			<div id="post-body" class="metabox-holder columns-2">
				<?php
				printf( '<div id="everest-forms-%d" class="everest-forms-edit-entry-container">', (int) $form_id );
				echo '<form ' . evf_html_attributes( $form_atts['id'], $form_atts['class'], $form_atts['data'], $form_atts['atts'] ) . '>';
				?>
				<div id="post-body-content" style="position: relative;">
					<?php do_action( 'everest_forms_entry_details_edit_content', $entry, $form_data ); ?>
				</div>
				<div id="postbox-container-1" class="postbox-container">
					<!-- Entry Details metabox -->
					<div id="everest-forms-entry-details" class="stuffbox">
						<h2><?php esc_html_e( 'Entry Details', 'everest-forms-pro' ); ?></h2>
						<div class="inside evf-field-container">
							<div id="submitbox" class="submitbox">
								<div class="everest-forms-entry-details-meta">
									<p class="everest-forms-entry-id">
										<span class="dashicons dashicons-admin-network"></span>
										<?php esc_html_e( 'Entry ID:', 'everest-forms-pro' ); ?>
										<strong><?php echo absint( $entry_id ); ?></strong>
									</p>

									<p class="everest-forms-entry-date">
										<span class="dashicons dashicons-calendar"></span>
										<?php esc_html_e( 'Submitted:', 'everest-forms-pro' ); ?>
										<strong><?php echo date_i18n( esc_html__( 'M j, Y @ g:ia', 'everest-forms-pro' ), strtotime( $entry->date_created ) + ( get_option( 'gmt_offset' ) * 3600 ) ); // phpcs:ignore WordPress.Security.EscapeOutput ?> </strong>
									</p>

									<?php if ( ! empty( $entry->date_modified ) ) : ?>
										<p class="everest-forms-entry-modified">
											<span class="dashicons dashicons-calendar"></span>
											<?php esc_html_e( 'Modified:', 'everest-forms-pro' ); ?>
											<strong><?php echo date_i18n( esc_html__( 'M j, Y @ g:ia', 'everest-forms-pro' ), strtotime( $entry->date_modified ) + ( get_option( 'gmt_offset' ) * 3600 ) ); // phpcs:ignore WordPress.Security.EscapeOutput ?> </strong>
										</p>
									<?php endif; ?>

									<?php if ( ! empty( $entry->user_id ) && 0 !== $entry->user_id ) : ?>
										<p class="everest-forms-entry-user">
											<span class="dashicons dashicons-admin-users"></span>
											<?php
											esc_html_e( 'User:', 'everest-forms-pro' );
											$user      = get_userdata( $entry->user_id );
											$user_name = ! empty( $user->display_name ) ? $user->display_name : $user->user_login;
											// phpcs:ignore WordPress.WP.GlobalVariablesOverride
											$user_url = add_query_arg(
												array(
													'user_id' => absint( $user->ID ),
												),
												admin_url( 'user-edit.php' )
											);
											?>
											<strong><a href="<?php echo esc_url( $user_url ); ?>"><?php echo esc_html( $user_name ); ?></a></strong>
										</p>
									<?php endif; ?>

									<?php if ( ! empty( $entry->user_ip_address ) ) : ?>
										<p class="everest-forms-entry-ip">
											<span class="dashicons dashicons-location"></span>
											<?php esc_html_e( 'User IP:', 'everest-forms-pro' ); ?>
											<strong><?php echo esc_html( $entry->user_ip_address ); ?></strong>
										</p>
									<?php endif; ?>

									<?php if ( ! empty( $entry->referer ) ) : ?>
										<p class="everest-forms-entry-referer">
											<span class="dashicons dashicons-admin-links"></span>
											<?php esc_html_e( 'Referer Link:', 'everest-forms-pro' ); ?>
											<strong><a href="<?php echo esc_url( $entry->referer ); ?>" target="_blank"><?php esc_html_e( 'View', 'everest-forms-pro' ); ?></a></strong>
										</p>
									<?php endif; ?>
								</div>

								<?php if ( current_user_can( 'everest_forms_edit_entry', $entry->entry_id ) || current_user_can( 'everest_forms_delete_entry', $entry->entry_id ) ) : ?>
									<div id="major-publishing-actions">
										<?php do_action( 'everest_forms_entry_details_sidebar_action', $entry, $form_data ); ?>
										<?php if ( current_user_can( 'everest_forms_delete_entry', $entry->entry_id ) ) : ?>
											<div id="delete-action">
												<a class="submitdelete" aria-label="<?php echo esc_attr__( 'Move to trash', 'everest-forms-pro' ); ?>" href="<?php echo esc_url( $trash_link ); ?>"><?php esc_html_e( 'Move to trash', 'everest-forms-pro' ); ?></a>
											</div>
										<?php endif; ?>
										<div class="clear"></div>
									</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
				</form>
				</div>
			</div>
		</div>
	</div>
</div>

<!--  Toggle displaying empty fields. -->
<script type="text/javascript">
	jQuery( document ).on( 'click', '#everest-forms-entry-fields .everest-forms-empty-field-toggle', function( event ) {
		event.preventDefault();

		// Handle cookie.
		if ( wpCookies.get( 'everest_forms_entry_hide_empty' ) === 'true' ) {

			// User was hiding empty fields, so now display them.
			wpCookies.remove( 'everest_forms_entry_hide_empty' );
			jQuery( this ).text( 'Hide Empty Fields' );
		} else {

			// User was seeing empty fields, so now hide them.
			wpCookies.set( 'everest_forms_entry_hide_empty', 'true', 2592000 ); // 1month.
			jQuery( this ).text( 'Show Empty Fields' );
		}

		jQuery( '.everest-forms-edit-entry-field.empty' ).toggle();
	});
</script>
<?php
wp_print_admin_notice_templates();
