<?php
/**
 * Plugin Name: Everest Forms - Multi-Part Forms
 * Plugin URI: https://wpeverest.com/wordpress-plugins/everest-forms/multi-part-forms/
 * Description: Everest Forms Multi-Part addon allows you to break long or complex forms up into multiple pages.
 * Version: 1.3.9
 * Author: WPEverest
 * Author URI: https://wpeverest.com
 * Text Domain: everest-forms-multi-part
 * Domain Path: /languages/
 * EVF requires at least: 1.7.0
 * EVF tested up to: 1.8.2
 *
 * @package EverestForms_MultiPart
 */

defined( 'ABSPATH' ) || exit;

// Define plugin version.
if ( ! defined( 'EVF_MULTI_PART_VERSION' ) ) {
	define( 'EVF_MULTI_PART_VERSION', '1.3.8' );
}

// Define plugin root file.
if ( ! defined( 'EVF_MULTI_PART_PLUGIN_FILE' ) ) {
	define( 'EVF_MULTI_PART_PLUGIN_FILE', __FILE__ );
}

// Include the main EverestForms_MultiPart class.
if ( ! class_exists( 'EverestForms_MultiPart' ) ) {
	include_once dirname( __FILE__ ) . '/includes/class-everest-forms-multi-part.php';
}

// Initialize the plugin.
add_action( 'plugins_loaded', array( 'EverestForms_MultiPart', 'get_instance' ) );
