/**
 * EverestFormsFR JS
 */
( function ($) {
	var EverestFormsFR = {

		init: function() {
			EverestFormsFR.bindUIActions();
		},

		/**
		 * Element bindings
		 */
		bindUIActions: function() {
			$('.everest-forms-submission-date input').flatpickr({
				enableTime: true,
				time_24hr: true
			});
			$( document ).on( 'change', '.evf-content-form-restriction-settings .everest-forms-toggle-form input', function(e) {
				EverestFormsFR.toggleContentMaxEntries(e, this);
			});
			$( document ).on( 'click', 'span.evf-handler-counter__button', function(e) {
				EverestFormsFR.counterEntries(e, this);
			});
		},

		toggleContentMaxEntries: function( e, el ) {
			var $this = $( el ),
			value = $this.prop('checked');

			if ( value === false ) {
				$this.closest('.evf-toggle-section-wrapper').find('.evf-hidden-content').addClass('everest-forms-hidden');
			} else if( value === true ){
				$this.closest('.evf-toggle-section-wrapper').find('.evf-hidden-content').removeClass('everest-forms-hidden');
			}
		},

		counterEntries: function( e, el ) {
			var $this = $( el ),
				value = parseInt( $this.closest('.evf-handler-counter').find('.evf-handler-counter__input').val() );
				if ( isNaN(value) ){
					value = 0;
				}

				if ( $this.hasClass('evf-handler-counter__button-plus') ) {
					value = value+1;
					$this.closest('.evf-handler-counter').find('.evf-handler-counter__input').val(value);
				} else if ( $this.hasClass('evf-handler-counter__button-minus') && value > 0 ) {
					value = value-1;
					$this.closest('.evf-handler-counter').find('.evf-handler-counter__input').val(value);
				}
		}
	}

	EverestFormsFR.init(jQuery);
})( jQuery );
