/* global everest_forms_captcha_params */
jQuery( function ( $ ) {

	var everest_forms_captcha = {

		/**
		 * Initialize.
		 *
		 * @since 1.0.0
		 */
		init: function() {
			this.load_validation();

			// Populate random equations for math captchas.
			$( '.everest-forms-captcha-equation' ).each( function() {
				var $captcha = $( this ).parent(),
					calc     = everest_forms_captcha_params.cal[ Math.floor( Math.random() * everest_forms_captcha_params.cal.length ) ],
					n1       = everest_forms_captcha.randomNumber( everest_forms_captcha_params.min, everest_forms_captcha_params.max ),
					n2       = everest_forms_captcha.randomNumber( everest_forms_captcha_params.min, everest_forms_captcha_params.max );

				$captcha.find( 'span.n1' ).text( n1 );
				$captcha.find( 'input.n1' ).val( n1 );
				$captcha.find( 'span.n2' ).text( n2 );
				$captcha.find( 'input.n2' ).val( n2 );
				$captcha.find( 'span.cal' ).text( calc );
				$captcha.find( 'input.cal' ).val( calc );
				$captcha.find( 'input.a' ).attr( {
					'data-cal': calc,
					'data-n1': n1,
					'data-n2': n2
				} );
			} );
		},

		/**
		 * Custom captcha validation for jQuery Validation.
		 *
		 * @since 1.1.0
		 */
		load_validation: function() {
			if ( typeof $.fn.validate === 'undefined' ) {
				return false;
			}

			// Validate confirmations.
			$.validator.addMethod( 'evf-captcha', function( value, element, param ) {
				var a, res, $el = $( element );

				if ( 'math' === param ) {
					// Math captcha.
					var n1  = Number( $el.attr( 'data-n1' ) ),
						n2  = Number( $el.attr( 'data-n2' ) ),
						cal = $el.attr( 'data-cal' );

					a   = Number( value );
					res = false;

					switch ( cal ) {
						case '-' :
							res = ( n1 - n2 );
							break;
						case '+' :
							res = ( n1 + n2 );
							break;
						case '*' :
							res = ( n1 * n2 );
							break;
					}
				} else {
					// Question answer captcha.
					a   = $.trim( value.toString().toLowerCase() );
					res = $.trim( $el.attr( 'data-a' ).toString().toLowerCase() );
				}

				return this.optional( element ) || a === res;
			}, $.validator.format( everest_forms_captcha_params.i18n_messages_error ) );
		},

		/**
		 * Generate random whole number.
		 *
		 * @since 1.0.0
		 *
		 * @param int $min Max number.
		 * @param int $max Max number.
		 *
		 * @return int
		 */
		randomNumber: function( min, max ) {
			return Math.floor( Math.random() * ( Number( max ) - Number( min ) + 1) ) + Number( min );
		}
	};

	everest_forms_captcha.init();
});
