<?php
/**
 * EverestForms Info and Message Config Functions
 *
 * @package EverestForms_Style_Customizer/Functions
 * @version 1.0.7
 */

defined( 'ABSPATH' ) || exit;

/**
 * Add everest forms Info and Message customizer sections.
 *
 * @param array $panels Array of panels.
 */
function evf_style_customizer_submission_message_panels( $panels ) {
	return array_merge(
		$panels,
		array(
			'everest_forms_submission_message' => array(
				'title'       => esc_html__( 'Form Messages', 'everest-forms-style-customizer' ),
				'description' => esc_html__( 'This is field Submission message description.', 'everest-forms-style-customizer' ),
			),
		)
	);
}
add_filter( 'everest_forms_style_customizer_panels', 'evf_style_customizer_submission_message_panels' );

/**
 * Add everest forms Info and Message customizer sections.
 *
 * @param array $sections Array of sections.
 */
function evf_style_customizer_submission_message_sections( $sections ) {
	return array_merge(
		$sections,
		array(
			'everest_forms_submission_success_message'    => array(
				'title'              => esc_html__( 'Success Message', 'everest-forms-style-customizer' ),
				'description'        => esc_html__( 'This is field Submission message description.', 'everest-forms-style-customizer' ),
				'priority'           => 10,
				'panel'              => 'everest_forms_submission_message',
				'description_hidden' => true,
			),
			'everest_forms_submission_error_message'      => array(
				'title'              => esc_html__( 'Error Message', 'everest-forms-style-customizer' ),
				'description'        => esc_html__( 'This is field Submission message description.', 'everest-forms-style-customizer' ),
				'priority'           => 10,
				'panel'              => 'everest_forms_submission_message',
				'description_hidden' => true,
			),
			'everest_forms_submission_info_message'       => array(
				'title'              => esc_html__( 'Info Message', 'everest-forms-style-customizer' ),
				'description'        => esc_html__( 'This is field Submission message description.', 'everest-forms-style-customizer' ),
				'priority'           => 10,
				'panel'              => 'everest_forms_submission_message',
				'description_hidden' => true,
			),
			'everest_forms_submission_warning_message'    => array(
				'title'              => esc_html__( 'Warning Message', 'everest-forms-style-customizer' ),
				'description'        => esc_html__( 'This is field Submission message description.', 'everest-forms-style-customizer' ),
				'priority'           => 10,
				'panel'              => 'everest_forms_submission_message',
				'description_hidden' => true,
			),
			'everest_forms_submission_validation_message' => array(
				'title'              => esc_html__( 'Validation Message', 'everest-forms-style-customizer' ),
				'description'        => esc_html__( 'This is field validation message description.', 'everest-forms-style-customizer' ),
				'priority'           => 10,
				'panel'              => 'everest_forms_submission_message',
				'description_hidden' => true,
			),
		)
	);
}
add_filter( 'everest_forms_style_customizer_sections', 'evf_style_customizer_submission_message_sections' );

/**
 * Add everest forms style customizer controls.
 *
 * @param array $controls Array of controls.
 */
function evf_style_customizer_submission_message_controls( $controls ) {
	$section_types = array( 'success_message', 'error_message', 'validation_message' );
	foreach ( $section_types as $section_name ) {
		$controls[ $section_name ] = array(
			'show_submission_message' => array(
				'setting' => array(
					'default' => false,
				),
				'control' => array(
					'label'   => esc_html__( 'Show message for customize', 'everest-forms-style-customizer' ),
					'section' => 'everest_forms_submission_' . $section_name,
					'type'    => 'EVF_Customize_Toggle_Control',
				),
			),

			'font_size'               => array(
				'setting' => array(
					'default'           => '14',
					'sanitize_callback' => 'sanitize_text_field',
				),
				'control' => array(
					'label'       => esc_html__( 'Font Size', 'everest-forms-style-customizer' ),
					'section'     => 'everest_forms_submission_' . $section_name,
					'type'        => 'EVF_Customize_Slider_Control',
					'input_attrs' => array(
						'min'  => 1,
						'max'  => 100,
						'step' => 1,
					),
				),
			),
			'font_style'              => array(
				'setting' => array(
					'default' => array(
						'bold'      => false,
						'italic'    => false,
						'underline' => false,
						'uppercase' => false,
					),
				),
				'control' => array(
					'label'   => esc_html__( 'Font Style', 'everest-forms-style-customizer' ),
					'section' => 'everest_forms_submission_' . $section_name,
					'type'    => 'EVF_Customize_Image_Checkbox_Control',
					'choices' => array(
						'bold'      => array(
							'name'  => esc_html__( 'Bold', 'everest-forms-style-customizer' ),
							'image' => plugins_url( 'assets/images/bold.svg', EVF_STYLE_CUSTOMIZER_PLUGIN_FILE ),
						),
						'italic'    => array(
							'name'  => esc_html__( 'Italic', 'everest-forms-style-customizer' ),
							'image' => plugins_url( 'assets/images/italic.svg', EVF_STYLE_CUSTOMIZER_PLUGIN_FILE ),
						),
						'underline' => array(
							'name'  => esc_html__( 'Underline', 'everest-forms-style-customizer' ),
							'image' => plugins_url( 'assets/images/underline.svg', EVF_STYLE_CUSTOMIZER_PLUGIN_FILE ),
						),
						'uppercase' => array(
							'name'  => esc_html__( 'Uppercase', 'everest-forms-style-customizer' ),
							'image' => plugins_url( 'assets/images/uppercase.svg', EVF_STYLE_CUSTOMIZER_PLUGIN_FILE ),
						),
					),
				),
			),
			'text_alignment'          => array(
				'setting' => array(
					'default'           => 'left',
					'sanitize_callback' => 'sanitize_text_field',
				),
				'control' => array(
					'label'   => esc_html__( 'Text Alignment', 'everest-forms-style-customizer' ),
					'section' => 'everest_forms_submission_' . $section_name,
					'type'    => 'EVF_Customize_Image_Radio_Control',
					'choices' => array(
						'left'   => array(
							'name'  => esc_html__( 'Left', 'everest-forms-style-customizer' ),
							'image' => plugins_url( 'assets/images/align-left.svg', EVF_STYLE_CUSTOMIZER_PLUGIN_FILE ),
						),
						'center' => array(
							'name'  => esc_html__( 'Center', 'everest-forms-style-customizer' ),
							'image' => plugins_url( 'assets/images/align-center.svg', EVF_STYLE_CUSTOMIZER_PLUGIN_FILE ),
						),
						'right'  => array(
							'name'  => esc_html__( 'Right', 'everest-forms-style-customizer' ),
							'image' => plugins_url( 'assets/images/align-right.svg', EVF_STYLE_CUSTOMIZER_PLUGIN_FILE ),
						),
					),
				),
			),
			'font_color'              => array(
				'setting' => array(
					'default' => '#fff',
				),
				'control' => array(
					'label'   => esc_html__( 'Font Color', 'everest-forms-style-customizer' ),
					'section' => 'everest_forms_submission_' . $section_name,
					'type'    => 'EVF_Customize_Color_Control',
				),
			),
			'background_color'        => array(
				'setting' => array(
					'default'           => '#fff',
					'sanitize_callback' => 'sanitize_text_field',
				),
				'control' => array(
					'label'   => esc_html__( 'Background Color', 'everest-forms-style-customizer' ),
					'section' => 'everest_forms_submission_' . $section_name,
					'type'    => 'EVF_Customize_Color_Control',
				),
			),
			'border_type'             => array(
				'setting' => array(
					'default'           => 'none',
					'sanitize_callback' => 'sanitize_text_field',
				),
				'control' => array(
					'type'    => 'select',
					'label'   => esc_html__( 'Border Type', 'everest-forms-style-customizer' ),
					'section' => 'everest_forms_submission_' . $section_name,
					'choices' => array(
						'none'    => esc_html__( 'None', 'everest-forms-style-customizer' ),
						'hidden'  => esc_html__( 'Hidden', 'everest-forms-style-customizer' ),
						'dotted'  => esc_html__( 'Dotted', 'everest-forms-style-customizer' ),
						'dashed'  => esc_html__( 'Dashed', 'everest-forms-style-customizer' ),
						'solid'   => esc_html__( 'Solid', 'everest-forms-style-customizer' ),
						'double'  => esc_html__( 'Double', 'everest-forms-style-customizer' ),
						'groove'  => esc_html__( 'Groove', 'everest-forms-style-customizer' ),
						'ridge'   => esc_html__( 'Ridge', 'everest-forms-style-customizer' ),
						'inset'   => esc_html__( 'Inset', 'everest-forms-style-customizer' ),
						'outset'  => esc_html__( 'Outset', 'everest-forms-style-customizer' ),
						'initial' => esc_html__( 'Initial', 'everest-forms-style-customizer' ),
						'inherit' => esc_html__( 'Inherit', 'everest-forms-style-customizer' ),
					),
				),
			),
			'border_width'            => array(
				'setting' => array(
					'default' => array(
						'top'    => 0,
						'right'  => 0,
						'bottom' => 0,
						'left'   => 0,
					),
				),
				'control' => array(
					'label'       => esc_html__( 'Border Width', 'everest-forms-style-customizer' ),
					'section'     => 'everest_forms_submission_' . $section_name,
					'type'        => 'EVF_Customize_Dimension_Control',
					'input_attrs' => array(
						'min' => 0,
					),
					'custom_args' => array(
						'anchor'     => true,
						'input_type' => 'number',
					),
				),
			),
			'border_color'            => array(
				'setting' => array(
					'default'           => '#cccccc',
					'sanitize_callback' => 'sanitize_text_field',
				),
				'control' => array(
					'label'   => esc_html__( 'Border Color', 'everest-forms-style-customizer' ),
					'section' => 'everest_forms_submission_' . $section_name,
					'type'    => 'EVF_Customize_Color_Control',
				),
			),
			'border_radius'           => array(
				'setting' => array(
					'default' => array(
						'top'    => 5,
						'right'  => 5,
						'bottom' => 5,
						'left'   => 5,
						'unit'   => 'px',
					),
				),
				'control' => array(
					'label'       => esc_html__( 'Border Radius', 'everest-forms-style-customizer' ),
					'section'     => 'everest_forms_submission_' . $section_name,
					'type'        => 'EVF_Customize_Dimension_Control',
					'input_attrs' => array(
						'min' => 0,
					),
					'custom_args' => array(
						'anchor'       => true,
						'input_type'   => 'number',
						'unit_choices' => array(
							'px' => esc_attr__( 'PX', 'everest-forms-style-customizer' ),
							'%'  => esc_attr__( '%', 'everest-forms-style-customizer' ),
						),
					),
				),
			),
		);
	}

	// Set default font and background colors.
	$controls['validation_message']['font_color']['setting']['default']    = '#fa5252';
	$controls['success_message']['background_color']['setting']['default'] = '#5cb85c';
	$controls['error_message']['background_color']['setting']['default']   = '#d9534f';

	return $controls;
}
add_filter( 'everest_forms_style_customizer_controls', 'evf_style_customizer_submission_message_controls' );
