/*!
 * Signature Pad v3.0.0-beta.3 | https://github.com/szimek/signature_pad
 * (c) 2018 Szymon Nowak | Released under the MIT license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?module.exports=e():"function"==typeof define&&define.amd?define(e):t.SignaturePad=e()}(this,function(){"use strict";var y=function(){function t(t,e,o){this.x=t,this.y=e,this.time=o||Date.now()}return t.prototype.distanceTo=function(t){return Math.sqrt(Math.pow(this.x-t.x,2)+Math.pow(this.y-t.y,2))},t.prototype.equals=function(t){return this.x===t.x&&this.y===t.y&&this.time===t.time},t.prototype.velocityFrom=function(t){return this.time!==t.time?this.distanceTo(t)/(this.time-t.time):0},t}(),s=function(){function i(t,e,o,n,i,s){this.startPoint=t,this.control2=e,this.control1=o,this.endPoint=n,this.startWidth=i,this.endWidth=s}return i.fromPoints=function(t,e){var o=this.calculateControlPoints(t[0],t[1],t[2]).c2,n=this.calculateControlPoints(t[1],t[2],t[3]).c1;return new i(t[1],o,n,t[2],e.start,e.end)},i.calculateControlPoints=function(t,e,o){var n=t.x-e.x,i=t.y-e.y,s=e.x-o.x,r=e.y-o.y,h=(t.x+e.x)/2,a=(t.y+e.y)/2,c=(e.x+o.x)/2,u=(e.y+o.y)/2,d=Math.sqrt(n*n+i*i),l=Math.sqrt(s*s+r*r),v=l/(d+l),p=c+(h-c)*v,f=u+(a-u)*v,_=e.x-p,m=e.y-f;return{c1:new y(h+_,a+m),c2:new y(c+_,u+m)}},i.prototype.length=function(){for(var t,e,o=0,n=0;n<=10;n+=1){var i=n/10,s=this.point(i,this.startPoint.x,this.control1.x,this.control2.x,this.endPoint.x),r=this.point(i,this.startPoint.y,this.control1.y,this.control2.y,this.endPoint.y);if(0<n){var h=s-t,a=r-e;o+=Math.sqrt(h*h+a*a)}t=s,e=r}return o},i.prototype.point=function(t,e,o,n,i){return e*(1-t)*(1-t)*(1-t)+3*o*(1-t)*(1-t)*t+3*n*(1-t)*t*t+i*t*t*t},i}();return function(){function i(t,e){void 0===e&&(e={});var o=this;this.canvas=t,this.options=e,this._handleMouseDown=function(t){1===t.which&&(o._mouseButtonDown=!0,o._strokeBegin(t))},this._handleMouseMove=function(t){o._mouseButtonDown&&o._strokeMoveUpdate(t)},this._handleMouseUp=function(t){1===t.which&&o._mouseButtonDown&&(o._mouseButtonDown=!1,o._strokeEnd(t))},this._handleTouchStart=function(t){if(t.preventDefault(),1===t.targetTouches.length){var e=t.changedTouches[0];o._strokeBegin(e)}},this._handleTouchMove=function(t){t.preventDefault();var e=t.targetTouches[0];o._strokeMoveUpdate(e)},this._handleTouchEnd=function(t){if(t.target===o.canvas){t.preventDefault();var e=t.changedTouches[0];o._strokeEnd(e)}},this.velocityFilterWeight=e.velocityFilterWeight||.7,this.minWidth=e.minWidth||.5,this.maxWidth=e.maxWidth||2.5,this.throttle="throttle"in e?e.throttle:16,this.minDistance="minDistance"in e?e.minDistance:5,this.throttle?this._strokeMoveUpdate=function n(i,s){void 0===s&&(s=250);var r,h,a,c=0,u=null,d=function(){c=Date.now(),u=null,r=i.apply(h,a),u||(h=null,a=[])};return function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];var o=Date.now(),n=s-(o-c);return h=this,a=t,n<=0||s<n?(u&&(clearTimeout(u),u=null),c=o,r=i.apply(h,a),u||(h=null,a=[])):u||(u=window.setTimeout(d,n)),r}}(i.prototype._strokeUpdate,this.throttle):this._strokeMoveUpdate=i.prototype._strokeUpdate,this.dotSize=e.dotSize||function(){return(this.minWidth+this.maxWidth)/2},this.penColor=e.penColor||"black",this.backgroundColor=e.backgroundColor||"rgba(0,0,0,0)",this.onBegin=e.onBegin,this.onEnd=e.onEnd,this._ctx=t.getContext("2d"),this.clear(),this.on()}return i.prototype.clear=function(){var t=this._ctx,e=this.canvas;t.fillStyle=this.backgroundColor,t.clearRect(0,0,e.width,e.height),t.fillRect(0,0,e.width,e.height),this._data=[],this._reset(),this._isEmpty=!0},i.prototype.fromDataURL=function(t,e,o){var n=this;void 0===e&&(e={});var i=new Image,s=e.ratio||window.devicePixelRatio||1,r=e.width||this.canvas.width/s,h=e.height||this.canvas.height/s;this._reset(),i.onload=function(){n._ctx.drawImage(i,0,0,r,h),o&&o()},i.onerror=function(t){o&&o(t)},i.src=t,this._isEmpty=!1},i.prototype.toDataURL=function(t,e){switch(void 0===t&&(t="image/png"),t){case"image/svg+xml":return this._toSVG();default:return this.canvas.toDataURL(t,e)}},i.prototype.on=function(){this.canvas.style.touchAction="none",this.canvas.style.msTouchAction="none",window.PointerEvent?this._handlePointerEvents():(this._handleMouseEvents(),"ontouchstart"in window&&this._handleTouchEvents())},i.prototype.off=function(){this.canvas.style.touchAction="auto",this.canvas.style.msTouchAction="auto",this.canvas.removeEventListener("pointerdown",this._handleMouseDown),this.canvas.removeEventListener("pointermove",this._handleMouseMove),document.removeEventListener("pointerup",this._handleMouseUp),this.canvas.removeEventListener("mousedown",this._handleMouseDown),this.canvas.removeEventListener("mousemove",this._handleMouseMove),document.removeEventListener("mouseup",this._handleMouseUp),this.canvas.removeEventListener("touchstart",this._handleTouchStart),this.canvas.removeEventListener("touchmove",this._handleTouchMove),this.canvas.removeEventListener("touchend",this._handleTouchEnd)},i.prototype.isEmpty=function(){return this._isEmpty},i.prototype.fromData=function(t){var n=this;this.clear(),this._fromData(t,function(t){var e=t.color,o=t.curve;return n._drawCurve({color:e,curve:o})},function(t){var e=t.color,o=t.point;return n._drawDot({color:e,point:o})}),this._data=t},i.prototype.toData=function(){return this._data},i.prototype._strokeBegin=function(t){var e={color:this.penColor,points:[]};"function"==typeof this.onBegin&&this.onBegin(t),this._data.push(e),this._reset(),this._strokeUpdate(t)},i.prototype._strokeUpdate=function(t){var e=t.clientX,o=t.clientY,n=this._createPoint(e,o),i=this._data[this._data.length-1],s=i.points,r=0<s.length&&s[s.length-1],h=!!r&&n.distanceTo(r)<=this.minDistance,a=i.color;if(!r||!r||!h){var c=this._addPoint(n);r?c&&this._drawCurve({color:a,curve:c}):this._drawDot({color:a,point:n}),s.push({time:n.time,x:n.x,y:n.y})}},i.prototype._strokeEnd=function(t){this._strokeUpdate(t),"function"==typeof this.onEnd&&this.onEnd(t)},i.prototype._handlePointerEvents=function(){this._mouseButtonDown=!1,this.canvas.addEventListener("pointerdown",this._handleMouseDown),this.canvas.addEventListener("pointermove",this._handleMouseMove),document.addEventListener("pointerup",this._handleMouseUp)},i.prototype._handleMouseEvents=function(){this._mouseButtonDown=!1,this.canvas.addEventListener("mousedown",this._handleMouseDown),this.canvas.addEventListener("mousemove",this._handleMouseMove),document.addEventListener("mouseup",this._handleMouseUp)},i.prototype._handleTouchEvents=function(){this.canvas.addEventListener("touchstart",this._handleTouchStart),this.canvas.addEventListener("touchmove",this._handleTouchMove),this.canvas.addEventListener("touchend",this._handleTouchEnd)},i.prototype._reset=function(){this._lastPoints=[],this._lastVelocity=0,this._lastWidth=(this.minWidth+this.maxWidth)/2,this._ctx.fillStyle=this.penColor},i.prototype._createPoint=function(t,e){var o=this.canvas.getBoundingClientRect();return new y(t-o.left,e-o.top,(new Date).getTime())},i.prototype._addPoint=function(t){var e=this._lastPoints;if(e.push(t),2<e.length){3===e.length&&e.unshift(e[0]);var o=this._calculateCurveWidths(e[1],e[2]),n=s.fromPoints(e,o);return e.shift(),n}return null},i.prototype._calculateCurveWidths=function(t,e){var o=this.velocityFilterWeight*e.velocityFrom(t)+(1-this.velocityFilterWeight)*this._lastVelocity,n=this._strokeWidth(o),i={end:n,start:this._lastWidth};return this._lastVelocity=o,this._lastWidth=n,i},i.prototype._strokeWidth=function(t){return Math.max(this.maxWidth/(t+1),this.minWidth)},i.prototype._drawCurveSegment=function(t,e,o){var n=this._ctx;n.moveTo(t,e),n.arc(t,e,o,0,2*Math.PI,!1),this._isEmpty=!1},i.prototype._drawCurve=function(t){var e=t.color,o=t.curve,n=this._ctx,i=o.endWidth-o.startWidth,s=2*Math.floor(o.length());n.beginPath(),n.fillStyle=e;for(var r=0;r<s;r+=1){var h=r/s,a=h*h,c=a*h,u=1-h,d=u*u,l=d*u,v=l*o.startPoint.x;v+=3*d*h*o.control1.x,v+=3*u*a*o.control2.x,v+=c*o.endPoint.x;var p=l*o.startPoint.y;p+=3*d*h*o.control1.y,p+=3*u*a*o.control2.y,p+=c*o.endPoint.y;var f=o.startWidth+c*i;this._drawCurveSegment(v,p,f)}n.closePath(),n.fill()},i.prototype._drawDot=function(t){var e=t.color,o=t.point,n=this._ctx,i="function"==typeof this.dotSize?this.dotSize():this.dotSize;n.beginPath(),this._drawCurveSegment(o.x,o.y,i),n.closePath(),n.fillStyle=e,n.fill()},i.prototype._fromData=function(t,e,o){for(var n=0,i=t;n<i.length;n++){var s=i[n],r=s.color,h=s.points;if(1<h.length)for(var a=0;a<h.length;a+=1){var c=h[a],u=new y(c.x,c.y,c.time);this.penColor=r,0===a&&this._reset();var d=this._addPoint(u);d&&e({color:r,curve:d})}else this._reset(),o({color:r,point:h[0]})}},i.prototype._toSVG=function(){var s=this,t=this._data,e=Math.max(window.devicePixelRatio||1,1),o=this.canvas.width/e,n=this.canvas.height/e,r=document.createElementNS("http://www.w3.org/2000/svg","svg");r.setAttribute("width",this.canvas.width.toString()),r.setAttribute("height",this.canvas.height.toString()),this._fromData(t,function(t){var e=t.color,o=t.curve,n=document.createElement("path");if(!(isNaN(o.control1.x)||isNaN(o.control1.y)||isNaN(o.control2.x)||isNaN(o.control2.y))){var i="M "+o.startPoint.x.toFixed(3)+","+o.startPoint.y.toFixed(3)+" C "+o.control1.x.toFixed(3)+","+o.control1.y.toFixed(3)+" "+o.control2.x.toFixed(3)+","+o.control2.y.toFixed(3)+" "+o.endPoint.x.toFixed(3)+","+o.endPoint.y.toFixed(3);n.setAttribute("d",i),n.setAttribute("stroke-width",(2.25*o.endWidth).toFixed(3)),n.setAttribute("stroke",e),n.setAttribute("fill","none"),n.setAttribute("stroke-linecap","round"),r.appendChild(n)}},function(t){var e=t.color,o=t.point,n=document.createElement("circle"),i="function"==typeof s.dotSize?s.dotSize():s.dotSize;n.setAttribute("r",i.toString()),n.setAttribute("cx",o.x.toString()),n.setAttribute("cy",o.y.toString()),n.setAttribute("fill",e),r.appendChild(n)});var i='<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 '+o+" "+n+'" width="'+o+'" height="'+n+'">',h=r.innerHTML;if(h===undefined){var a=document.createElement("dummy"),c=r.childNodes;a.innerHTML="";for(var u=0;u<c.length;u+=1)a.appendChild(c[u].cloneNode(!0));h=a.innerHTML}return"data:image/svg+xml;base64,"+btoa(i+h+"</svg>")},i}()});