<?php
/**
 * EverestForms Form Country Restriction.
 *
 * @package EverestForms_Form_Restriction\Country_Restriction
 * @version 1.0.1
 */

defined( 'ABSPATH' ) || exit;

if ( class_exists( 'EVFFR_Country_Restriction', false ) ) {
	return new EVFFR_Country_Restriction();
}

/**
 * EVFFR_Country_Restriction Class.
 */
class EVFFR_Country_Restriction {

	/**
	 * Constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		$this->hooks();
	}

	/**
	 * Locker hooks.
	 *
	 * @since 1.0.0
	 */
	public function hooks() {

		add_filter( 'everest_forms_frontend_load', array( $this, 'display_form' ), 10, 2 );
		// add_filter( 'everest_forms_process_initial_errors', array( $this, 'submit_form' ), 10, 2 );
	}

	/**
	 * Form Display Actions.
	 *
	 * @param bool  $load_form Form should be loaded or not.
	 * @param array $form_data Form Data.
	 */
	public function display_form( $load_form, $form_data ) {
		if ( empty( $form_data['settings']['form_restriction']['country_restriction'] ) ) {
			return $load_form;
		}

		$restricted_country = ! empty( $form_data['settings']['form_restriction']['restricted_country'] ) ? $form_data['settings']['form_restriction']['restricted_country'] : '';
		$visitor_ip         = $this->get_visitor_ip_address();

		$ipdata = @json_decode(
			file_get_contents(
				'http://www.geoplugin.net/json.gp?ip=' . $visitor_ip
			)
		);

		$visitor_country_code = $ipdata->geoplugin_countryCode;

		if ( $visitor_country_code === $restricted_country ) {
			add_action( 'everest_forms_frontend_not_loaded', array( $this, 'show_country_restriction_message' ), 10, 1 );
			return false;
		}
		return $load_form;

	}

	/**
	 * Get Visitor IP Address.
	 */
	public function get_visitor_ip_address() {
		if ( ! empty( $_SERVER['HTTP_CLIENT_IP'] ) ) {
			return $_SERVER['HTTP_CLIENT_IP'];
		} elseif ( ! empty( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ) {
			return $_SERVER['HTTP_X_FORWARDED_FOR'];
		} else {
			return $_SERVER['REMOTE_ADDR'];
		}
	}

	/**
	 * Show form expired message.
	 *
	 * @param array $form_data Form Data.
	 */
	public function show_country_restriction_message( $form_data ) {
		$message = ! empty( $form_data['settings']['form_restriction']['country_restriction_message'] ) ? $form_data['settings']['form_restriction']['country_restriction_message'] : '';
		if ( $message ) {
			printf( '<p class="everest-forms-notice everest-forms-notice--error">%s</p>', wp_kses_post( $message ) );
		}
	}
}
